<?php
/* --------------------------------------------------------------
 SmtpEncryption.php 2019-12-17
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2019 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Configuration\Types;

use Gambio\Core\Configuration\Models\Read\Collections\Options;
use Gambio\Core\Configuration\Models\Read\Option;
use Gambio\Core\Configuration\Repositories\Components\OptionsResolver;

/**
 * Class SmtpEncryption
 * @package Gambio\Core\Configuration\Types
 */
class SmtpEncryption implements ConfigurationType
{
    /**
     * @inheritDoc
     */
    public function toOptions(OptionsResolver $resolver, string $value = null): ?Options
    {
        $options = [
            Option::create('none', $resolver->getText('GM_CFG_NONE', 'gm_general')),
            Option::create('ssl', $resolver->getText('GM_CFG_SSL', 'gm_general')),
            Option::create('tls', $resolver->getText('GM_CFG_TLS', 'gm_general')),
        ];
        
        return Options::create(...$options);
    }
    
    
    /**
     * @inheritDoc
     */
    public function inputType(): string
    {
        return 'dropdown';
    }
}